Global Lump_List:TList = New TList
Type Lump
	Field Name:String
	Field Offset:Int
	Field Size:Int
	Field Data:TBank
	Field HasLoaded
	Function Add(TMP_Name:String, TMP_Offset:Int, TMP_Size:Int) 
		Local CABNET:Lump = New Lump
		CABNET.Name:String = TMP_Name:String
		CABNET.Offset:Int = TMP_Offset:Int
		CABNET.Size:Int = TMP_Size:Int
		CABNET.HasLoaded = False
		'CABNET.Data:String = TMP_DATA:String
		'Print Cabnet.Name + ":" + Cabnet.Offset + ":" + cabnet.Size
		ListAddLast(Lump_List, CABNET) 
	EndFunction
EndType
 
Global ARCH_File:TStream
Global ARCH_Header:String = ""
Global ARCH_TotalFiles:Int = 0
Global ARCH_DirOffset:Int = 0

Function RuntimeError(TMP_Text:String = "Error") 
	Notify(TMP_Text:String, True) 
	End
End Function

Function ARCH_Init(TMP_FileName:String = "ARCH.KIP") 
	ARCH_File:TStream = ReadFile(TMP_Filename:String) 	
	For x = 1 To 8
		ARCH_Header = ARCH_Header + Chr:String(ReadByte(ARCH_File)) 
	Next
	'Print ARCH_Header
	If(ARCH_Header <> "KIPARCHI") 
		RuntimeError(Upper(TMP_FileName:String) + " IS AN INVALID KIPARCHIVE") 
	EndIf
	ARCH_DirOffset = ReadInt(ARCH_File) 
	ARCH_TotalFiles = ReadInt(ARCH_File) 
	SeekStream(ARCH_File, ARCH_DirOffset) 
	For x = 1 To ARCH_TotalFiles
		Local TMP_Name:String
		Local TMP_Offset:Int
		Local TMP_Size
		For y = 1 To 8
			TMP_Name = TMP_Name + Chr:String(ReadByte(ARCH_File)) 
		Next
		TMP_Offset = ReadInt(ARCH_File) 
		TMP_Size = ReadInt(ARCH_File) 
		Lump.Add(TMP_Name, TMP_Offset, TMP_Size) 
	'	print "uhm"
	Next
End Function

'Dump all files to a folder called export
Function ARCH_Dump(TMP_FolderName:String = "DUMP") 
	For Local CABNET:Lump = EachIn Lump_List
		CABNET.Data = CreateBank(CABNET.Size) 
		SeekStream(ARCH_File, CABNET.Offset) 
		For x = 0 To CABNET.Size - 1
			PokeByte(CABNET.Data, x, ReadByte(ARCH_File)) 
			'Print "succ"
		Next
		CABNET.HasLoaded = True
		CreateDir(TMP_FolderName:String) 
		CreateFile(TMP_FolderName:String + "\" + CABNET.Name) 
		'CloseFile(EXTRACT) 
		TMP_EXTRACT = WriteFile(TMP_FolderName:String + "\" + CABNET.Name) 
		WriteBank(CABNET.Data, TMP_EXTRACT, 0, CABNET.Size) 
		'WriteString(EXTRACT, "ass") 
		CloseFile(TMP_EXTRACT) 
	Next
End Function

Function ARCH_DumpFile(TMP_LumpName:String) 
	CreateDir("DUMP") 
	CreateFile("DUMP\" + Left(Upper(TMP_LumpName) + "XXXXXXX", 8)) 
	'CloseFile(EXTRACT) 
	TMP_EXTRACT:TBank = ARCH_Read:TBank(TMP_LumpName:String) 
	SaveBank(TMP_EXTRACT, "DUMP\" + Left(Upper(TMP_LumpName) + "XXXXXXX", 8)) 
End Function

'Read a lump
Function ARCH_Read:TBank(TMP_LumpName:String) 
	For Local CABNET:Lump = EachIn Lump_List
		If(Left(Upper(TMP_LumpName) + "XXXXXXX", 8) = CABNET.Name) 
			If(CABNET.HasLoaded = False) 
				CABNET.Data = CreateBank(CABNET.Size) 
				SeekStream(ARCH_File, CABNET.Offset) 
				For x = 0 To CABNET.Size - 1
					PokeByte(CABNET.Data, x, ReadByte(ARCH_File)) 
				Next
				CABNET.HasLoaded = True
			EndIf
			Return CABNET.Data
			Exit
		EndIf
	Next
End Function

'Empty a lump
Function ARCH_Delet:TBank(TMP_LumpName:String) 
	For Local CABNET:Lump = EachIn Lump_List
		If(Left(Upper(TMP_LumpName) + "XXXXXXX", 8) = CABNET.Name) 
			If(CABNET.HasLoaded) 
				Cabnet.Data = TMP_Empty:TBank
				CABNET.HasLoaded = False
			EndIf
		EndIf
	Next
End Function

'Special function for combining music - BITWAVE
Function ARCH_ReadXM:TBank(TMP_LumpName:String, TMP_OPL = False) 
	Local TMP_Instuments:TBank
	If(TMP_OPL) 
		TMP_Instuments:TBank = ARCH_Read:TBank("KOPLINST") 
	Else
		TMP_Instuments:TBank = ARCH_Read:TBank("KINSTRUM") 
	EndIf
	Local TMP_Track:TBank = ARCH_Read(TMP_LumpName:String) 
	Local TMP_Combined:TBank = CreateBank(BankCapacity(TMP_Instuments:TBank) + BankCapacity(TMP_Track:TBank)) 
	
	'Don't forget to take 1 away while it's seeking offsets!
	For x = 1 To BankCapacity(TMP_Track:TBank) 
		PokeByte(TMP_Combined:TBank, x - 1, PeekByte(TMP_Track:TBank, x - 1)) 
	Next
	For x = 1 To BankCapacity(TMP_Instuments:TBank) 
		PokeByte(TMP_Combined:TBank, BankCapacity(TMP_Track:TBank) + x - 1, PeekByte(TMP_Instuments:TBank, x - 1)) 
	Next
	'Clear it afterwards
	ARCH_Delet(TMP_LumpName:String) 
	Return TMP_Combined:TBank
End Function

'Graphics(640, 480, 0, 60) 
'ARCH_Init() 
'SetColor(255, 0, 0) 
'DrawRect(0, 0, 32, 32) 
'teast:TImage = LoadImage(ARCH_Read("WOWI.PNG")) 
'DrawImage(teast, 0, 0) 
'Flip
'WaitKey
'ARCH_Dump() 
'CloseFile(ARCH_File) 
'Sndy = LoadSound(ARCH_Read("ALRAMCLK")) 
'PlaySound (Sndy) 
'WaitKey
